clear();
clc();
close all;                                                      %Plots schlieen

%KONFIGURATION---------------------------------------------------------------------
x                   = -2:0.0001:2.0;                            %Diagrammbereich:    %Syntax: links: for-Startwert; Mitte = for-Inkrement; rechts: for-Abbruchbedingung
y                   = @(x) exp(-x)-cos(x);                      %Funktion:           %Syntax: Beispiel: y = @(x) x.^3-5*x+3; exponenten mit ".^", statt "^" schreiben; Schreibe "5*x", statt "5x"
Xu                  = 1.1;                                      %Modus Intervall: Untere Grenze neben Nullstelle: aus Plot ablesen
Xo                  = 1.6;                                      %Modus Intervall: Untere Grenze neben Nullstelle: aus Plot ablesen
Modus               = 2;                                        %1 = Abbruchbedingung: exakte Nullstelle
                                                                %2 = Abbruchbedingung: Nachkommastelle
                                                                %3 = Abbruchbedingung: relativer Fehler
Nachkommastelle     = 12;
Relativer_Fehler    = 10^-4;                                    %Angabe nicht in Prozent sondern dezimal -> Maximum ist 1
sKommastellenDouble = '%.20f';                                   %Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%FUNKTIONSPLOT---------------------------------------------------------------------
xACHSE          = @(x) 0*x;
plot(x,y(x),'color','blue');
hold on;                                                        %Warten bis zur Plotausgabe
plot(x,xACHSE(x),'color','black');
grid on;
grid minor;

%EINGABEBEREICH--------------------------------------------------------------------
fprintf('%s\n',"Tragen Sie die Funktion in den Header des Skriptes ein!")
fprintf('%s\n',"Betrachten Sie den Plot der Funktion!")
fprintf('%s\n',"Whlen Sie eine Nullstelle um die sie eine Grenze ziehen mchten!")
fprintf('%s\n\n',"__________________________________________________________________");

%BERECHNUNG------------------------------------------------------------------------
aTABELLE=["i","Xi-1","Xi","Xi+1"];                              %Kopfzeile Mixed-Array

switch(Modus)
    case 1
        Xi=Xo;
        Xi_1=Xu;
        i=0;
        while(1)
            aTABELLE(i+2,1)=i;
            aTABELLE(i+2,2)=num2str(Xi_1,sKommastellenDouble);
            aTABELLE(i+2,3)=num2str(Xi,sKommastellenDouble);
            aTABELLE(i+2,4)=num2str(Xi-( ( (Xi-Xi_1) / (y(Xi)-y(Xi_1)) )*y(Xi)  ),sKommastellenDouble);
            if(aTABELLE(i+2,3) == aTABELLE(i+2,4))
                break;
            end 
            Xi=str2double(aTABELLE(i+2,4));
            Xi_1=str2double(aTABELLE(i+2,3));
            i=i+1;
        end
        fprintf('%s\n',"Berechnung abgebrochen, weil Xi=Xi+1");
        
    case 2
        Xi=Xo;
        Xi_1=Xu;
        i=0;
        while(1)
            aTABELLE(i+2,1)=i;
            aTABELLE(i+2,2)=num2str(Xi_1,sKommastellenDouble);
            aTABELLE(i+2,3)=num2str(Xi,sKommastellenDouble);
            aTABELLE(i+2,4)=num2str(Xi-( ( (Xi-Xi_1) / (y(Xi)-y(Xi_1)) )*y(Xi)  ),sKommastellenDouble);
            if(abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))) <= (1/(10^Nachkommastelle)))
                break;
            end 
            Xi=str2double(aTABELLE(i+2,4));
            Xi_1=str2double(aTABELLE(i+2,3));
            i=i+1;
        end
        switch(Nachkommastelle)
            case 0     
                fprintf('Genauigkeit fr %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.0f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))));
            case 1     
                fprintf('Genauigkeit fr %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.1f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))));
            case 2     
                fprintf('Genauigkeit fr %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.2f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))));       
            case 3     
                fprintf('Genauigkeit fr %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.3f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))));                        
            case 4     
                fprintf('Genauigkeit fr %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.4f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))));                        
            case 5     
                fprintf('Genauigkeit fr %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.5f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))));                       
            case 6     
                fprintf('Genauigkeit fr %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.6f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))));                        
            case 7     
                fprintf('Genauigkeit fr %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.7f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))));        
            case 8     
                fprintf('Genauigkeit fr %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.8f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))));     
            case 9     
                fprintf('Genauigkeit fr %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.9f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))));                        
            case 10     
                fprintf('Genauigkeit fr %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.10f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))));                        
            case 11     
                fprintf('Genauigkeit fr %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.11f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))));                        
            case 12     
                fprintf('Genauigkeit fr %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.12f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))));                       
            case 13     
                fprintf('Genauigkeit fr %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.13f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))));        
            otherwise
                 fprintf('Genauigkeit fr %u Nachkommastellen erreicht, da |Xi+1 - Xi| = %.21f\n',Nachkommastelle,abs(str2double(aTABELLE(i+2,3))-str2double(aTABELLE(i+2,4))));        
        end  
        
    case 3
        Xi=Xo;
        Xi_1=Xu;
        i=0;
        while(1)
            aTABELLE(i+2,1)=i;
            aTABELLE(i+2,2)=num2str(Xi_1,sKommastellenDouble);
            aTABELLE(i+2,3)=num2str(Xi,sKommastellenDouble);
            aTABELLE(i+2,4)=num2str(Xi-( ( (Xi-Xi_1) / (y(Xi)-y(Xi_1)) )*y(Xi)  ),sKommastellenDouble);
            if(abs(((str2double(aTABELLE(i+2,3)) - str2double(aTABELLE(i+2,2)))/str2double(aTABELLE(i+2,3))))<Relativer_Fehler)
                break;
            end 
            Xi=str2double(aTABELLE(i+2,4));
            Xi_1=str2double(aTABELLE(i+2,3));
            i=i+1;
        end
        fprintf('Berechnung abgebrochen, weil |(Xi-Xi_alt)/Xi| kleiner als |zulssiger relativer Fehler| %f < %f\n',abs(((str2double(aTABELLE(i+2,3)) - str2double(aTABELLE(i+2,2)))/str2double(aTABELLE(i+2,3)))),abs(Relativer_Fehler));
    otherwise
        fprintf('%s\n','Variable "Modus" nicht definiert!');
end

%AUSGABE----------------------------------------------------------------------------
fprintf('%s\n\n',"__________________________________________________________________");
disp(aTABELLE);

%PROGRAMMENDE-----------------------------------------------------------------------
clearvars -except aTABELLE                                                           %Workspace aufrumen